VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "CCRP FolderTreeview Control/WebBrowser demo (VB6)"
   ClientHeight    =   6150
   ClientLeft      =   2085
   ClientTop       =   2175
   ClientWidth     =   8865
   LinkTopic       =   "Form1"
   ScaleHeight     =   6150
   ScaleWidth      =   8865
   Begin VB.ComboBox Combo1 
      Height          =   315
      Left            =   630
      TabIndex        =   0
      Text            =   "Combo1"
      Top             =   750
      Width           =   3255
   End
   Begin FTV6WebBrowserDemo.ExplorerView ExplorerView1 
      Height          =   3465
      Left            =   780
      TabIndex        =   1
      Top             =   1590
      Width           =   7305
      _ExtentX        =   12885
      _ExtentY        =   6112
   End
   Begin VB.Menu mnuBack 
      Caption         =   "<-- &Back"
   End
   Begin VB.Menu mnuForward 
      Caption         =   "&Forward -->"
   End
   Begin VB.Menu mnuStop 
      Caption         =   "&Stop"
   End
   Begin VB.Menu mnuRefresh 
      Caption         =   "&Refresh"
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewLargeIcons 
         Caption         =   "Lar&ge Icons"
      End
      Begin VB.Menu mnuViewSmallIcons 
         Caption         =   "S&mall Icons"
      End
      Begin VB.Menu mnuViewList 
         Caption         =   "&List"
      End
      Begin VB.Menu mnuViewReport 
         Caption         =   "&Detatils"
      End
      Begin VB.Menu mnuViewThumbnails 
         Caption         =   "&Thumbnails"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'
' Brad Martinez,  http://www.mvps.org/ccrp/
'
Private Const WM_SETICON = &H80

'  WM_SETICON / WM_GETICON Type Codes
Private Const ICON_SMALL = 0
Private Const ICON_BIG = 1

'Private WithEvents FTV1 As FolderTreeview
Private WithEvents WB1 As WebBrowser
Attribute WB1.VB_VarHelpID = -1

' the ExplorerView's top coord.
Private m_yEV As Long
'

Private Sub Form_Load()

'  Set FTV1 = ExplorerView1.FolderTreeview
'  ' uncomment to watch WebBrowser events in the Immediate window
'  Set WB1 = ExplorerView1.WebBrowser
  
  ' This is cool, IE5 only though...
  If (ExplorerView1.ShellVersion >= 5) Then
    Call CoInitialize(0)
    Call SHAutoComplete(FindWindowEx(Combo1.hWnd, 0, "Edit", vbNullString), SHACF_DEFAULT)
  End If
  
  ' ======================================================
  ' Form

  ' Form1.ClipControls (WS_CLIPCHILDREN) must  be set
  ' to True, or the FTV and WebBrowser fail to paint properly...
  
  KeyPreview = True
  ScaleMode = vbPixels
  m_yEV = Combo1.Height + 2
  
  Move (Screen.Width - Width) * 0.5, (Screen.Height - Height) * 0.5
  
  ' ======================================================
  ' menus

  ' Starting in details view
  Call mnuViewReport_Click
  
  ' Just reading (not setting) thumbnail view...
  mnuViewThumbnails.Enabled = False
  
End Sub

Private Sub Form_Resize()
  
  If (WindowState <> vbMinimized) And (ScaleHeight > m_yEV) Then
    Call Combo1.Move(0, 0, ScaleWidth)
    Call ExplorerView1.Move(0, m_yEV, ScaleWidth, ScaleHeight - m_yEV)
  End If

End Sub

Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
  
  If (KeyCode = vbKeyF5) Then
    Call ExplorerView1.Refresh
  ElseIf (KeyCode = vbKeyEscape) Then
    Call ExplorerView1.CancelSplit
  End If

End Sub

Private Sub Form_Unload(Cancel As Integer)
'  Set FTV1 = Nothing
  Set WB1 = Nothing
End Sub

' update the form's icon and caption

Private Sub ExplorerView1_NavigateComplete(ByVal DisplayName As String, ByVal Path As String)
  
  Call SendMessage(hWnd, WM_SETICON, ICON_SMALL, _
                                ByVal CLng(ExplorerView1.SmallIcon.Handle))

  Call SendMessage(hWnd, WM_SETICON, ICON_BIG, _
                                ByVal CLng(ExplorerView1.LargeIcon.Handle))
    
  Caption = DisplayName
  Combo1 = Path
  
  mnuBack.Enabled = ExplorerView1.CanNavigateBack
  mnuForward.Enabled = ExplorerView1.CanNavigateForward
  
End Sub

' Process the combo entry on Enter key

Private Sub Combo1_KeyDown(KeyCode As Integer, Shift As Integer)
  
  If (KeyCode = vbKeyReturn) Then
    Call ExplorerView1.NavigateTo(Combo1)
'    KeyAscii = 0
  End If

End Sub

' ==============================================================
' menu commands

Private Sub mnuBack_Click()
  ExplorerView1.NavigateBack
End Sub

Private Sub mnuForward_Click()
  ExplorerView1.NavigateForward
End Sub

Private Sub mnuStop_Click()
  Call ExplorerView1.NavigateStop
End Sub

Private Sub mnuRefresh_Click()
  Call ExplorerView1.Refresh
End Sub

Private Sub mnuView_Click()
  Dim fEnabled As Boolean
  
  fEnabled = ((ExplorerView1.InWebView = False) And (ExplorerView1.View <> evThumbnails))
  mnuViewLargeIcons.Enabled = fEnabled
  mnuViewSmallIcons.Enabled = fEnabled
  mnuViewList.Enabled = fEnabled
  mnuViewReport.Enabled = fEnabled
  
  Call CheckMenus(ExplorerView1.View)

End Sub

Private Sub mnuViewLargeIcons_Click()
  ExplorerView1.View = evLargeIcons
  Call CheckMenus(evLargeIcons)
End Sub

Private Sub mnuViewSmallIcons_Click()
  ExplorerView1.View = evSmallIcons
  Call CheckMenus(evSmallIcons)
End Sub

Private Sub mnuViewList_Click()
  ExplorerView1.View = evList
  Call CheckMenus(evList)
End Sub

Private Sub mnuViewReport_Click()
  ExplorerView1.View = evDetails
  Call CheckMenus(evDetails)
End Sub

Private Sub CheckMenus(dwView As evViewConstants)
  mnuViewLargeIcons.Checked = (dwView = evLargeIcons)
  mnuViewSmallIcons.Checked = (dwView = evSmallIcons)
  mnuViewList.Checked = (dwView = evList)
  mnuViewReport.Checked = (dwView = evDetails)
  mnuViewThumbnails.Checked = (dwView = evThumbnails)
End Sub

' ==============================================================
' WebBrowser events

Private Sub WB1_BeforeNavigate2(ByVal pDisp As Object, URL As Variant, Flags As Variant, TargetFrameName As Variant, PostData As Variant, Headers As Variant, Cancel As Boolean)
  Debug.Print "BeforeNavigate2: " & URL, "Flags: " & Flags, "PostData: " & PostData, "Headers: " & Headers
End Sub

Private Sub WB1_CommandStateChange(ByVal Command As Long, ByVal Enable As Boolean)
  Debug.Print "CommandStateChange", Command
End Sub

Private Sub WB1_DocumentComplete(ByVal pDisp As Object, URL As Variant)
  Debug.Print "DocumentComplete LocationURL: " & WB1.LocationURL, "URL: " & URL ', "type: " & WB1.Type
End Sub

Private Sub WB1_NavigateComplete2(ByVal pDisp As Object, URL As Variant)
  Debug.Print "NavigateComplete2:", URL
End Sub

Private Sub WB1_ProgressChange(ByVal Progress As Long, ByVal ProgressMax As Long)
  Debug.Print "ProgressChange", Progress, ProgressMax
End Sub

Private Sub WB1_PropertyChange(ByVal szProperty As String)
  Debug.Print "PropertyChange", szProperty
End Sub

Private Sub WB1_StatusTextChange(ByVal Text As String)
  Debug.Print "StatusTextChange", Text
End Sub

Private Sub WB1_TitleChange(ByVal Text As String)
  Debug.Print "TitleChange:", Text
End Sub
